#!/bin/bash

# We strongly recomend to not just run this script, but to run this on a cluster with multiple GPUs and adapt the script to for example run 1 defense on 1 GPU.

task_name=tab3_BB #add your task name
defense=('hyperprior' 'HiFiC' 'CRDR' 'CRDR' 'jpeg' 'ELIC')
param=('quality:8' 'weights:low' 'quality:0.0 beta:5.12' 'quality:0.0 beta:0.0' 'quality:25.0' 'weights:0016')
type=''
eps='4/255 8/255 16/255'
attack='PGD' 
attack_steps=10
model=('ResNet50' 'Vit')
output='results/tab_3/'
exp_names=(hyperprior HiFiC CRDR_HR CRDR_LR jpeg ELIC)
mkdir -p $output

start_time=$(date +%s)
echo "Running task $task_name with defense: $defense, param: $param, type: $type, eps: $eps"
echo "GPU & CUDA info"
nvcc --version
nvidia-smi
echo "=============================================================="
source /conda.sh #path to your conda.sh
conda activate #add your conda environment

for i in {0..5}
do
    for m in "${model[@]}"
    do
        python run_experiment.py \
            --epsilons $eps \
            --attack=$attack \
            --attack_steps=$attack_steps  \
            --output=$output'_'$m'_'"${exp_names[$i]}"'_' \
            --save_config \
            --model_attack=$m \
            --defense="${defense[$i]}" \
            --defense_param "${param[$i]}" \
            --get_baseline \
            --dataset=imagenet \ 
            --batch_size=16 \
            $type
       done
    done
done
end_time=$(date +%s)
execution_time=$((end_time - start_time))

echo "Execution time: $execution_time seconds"
echo "finished"